`timescale 1ns/100ps
module test_bench_memloop;
reg write,d_in;
reg fault_FNO1, 
		fault_LSW1,
		fault_INV1, 
		fault1_MV2,
		fault0_MV2,
		fault_FNO2,
		fault_FNO3,
		fault_LSW5,
		fault_LSW3,
		fault1_MV3,
		fault0_MV3,
		fault1_MV1,
		fault0_MV1,
		fault_LSW2;
reg oldvalue;
reg [1:0] zone1,zone2,zone3,zone4;
wire out;
assign m17=oldvalue;
parameter [1:0]
	switch=1,
	hold=2,
	rele=3,
	relax=0;
	
Wire_4 W1(
	  .A(write),
	  .B(m0),
	  .status(zone1)
	  );
	  
Fanout_A4 FNO1(
		.A (write),
		.B (m1), 
		.C (m2), 
		.status(zone1),
		.fault(fault_FNO1)
		);
Wire_4 W8(
	  .A(d_in),
	  .B(m12),
	  .status(zone1)
	  );

Wire_4 W2(
	  .A(m2),
	  .B(m3),
	  .status(zone1));

Wire_4 W3(
	  .A(m1),
	  .B(m4),
	  .status(zone1));
	  	  		
LShapedWire_4 LSW1(
		.A(m4), 
		.B(m5), 
		.status(zone1),
		.fault(fault_LSW1)
		);		
		
Inverter_4 INV1 (
		.A(m5),
		.B(m6),
		.status(zone1),
		.fault(fault_INV1)
	);

MajorityVoter_4 MV2 (
		.A(m6), 
		.B(m14), 
		.C(1'b1), 
		.Zp(m7),
		.status(zone2),
		.fault1(fault1_MV2), 
		.fault0(fault0_MV2)
		);

LShapedWire_4 LSW2(
		.A(m7), 
		.B(m8), 
		.status(zone3),
		.fault(fault_LSW2)
		);
		
Wire_4 W5(
		.A(m11),
		.B(m14),
		.status(zone2)
		);

Wire_4 W9(
		.A(m8),
		.B(m9),
		.status(zone3)
		);		

Fanout_C4 FNO2(
		.C (m12),
		.B (m11), 
		.A (m13), 
		.status(zone2),
		.fault(fault_FNO2)
		);

		
MajorityVoter_4 MV1 (
		.A(m3), 
		.B(1'b0), 
		.C(m13), 
		.Zp(m16),
		.status(zone2),
		.fault1(fault1_MV1), 
		.fault0(fault0_MV1)
		);		

	
Wire_4 W4(.A(m16), 
	  .B(m15), 
	  .status(zone3)
	  );	
	  
		 	  
MajorityVoter_4 MV3 (
		.A(m15), 
		.B(m21), 
		.C(m9), 
		.Zp(m17),
		.status(zone4),
		.fault1(fault1_MV3), 
		.fault0(fault0_MV3)
		);		
	
LShapedWire_4 LSW3(
		.A(m20), 
		.B(m21), 
		.status(zone3),
		.fault(fault_LSW3)
		);		

Wire_4 W6(.A(m19), 
	  .B(m20), 
	  .status(zone3)
	  );			

Wire_4 W7(.A(m17), 
	  .B(m18), 
	  .status(zone1)
	  );	
	  
Fanout_A4 FNO3(
		.A (m18),
		.B (out), 
		.C (m10), 
		.status(zone2),
		.fault(fault_FNO3)
		);

LShapedWire_4 LSW4(
		.A(m10), 
		.B(m19), 
		.status(zone2),
		.fault(fault_LSW5)
		);
initial  
begin     
		fault_FNO1 <=0;
		fault_LSW1 <=0;
		fault_INV1 <=0;
		fault1_MV2 <=0;
		fault0_MV2 <=0;
		fault_FNO2 <=0;
		fault_LSW2 <=0;
		fault_FNO3 <=0;
		fault_LSW5 <=0;
		fault_LSW3 <=0;
		fault1_MV3 <=0;
		fault0_MV3 <=0;
		fault1_MV1 <=0;
		fault0_MV1 <=0;
		oldvalue<=0;
		write<=1;
		d_in<=1;
		zone1<=switch;
		zone2<=relax;
		zone3<=rele;
		zone4<=hold;
		#30 oldvalue=1'bz;
end     

always
	begin 
	#80 write <=0;
   	#40 d_in  <=0;
   	#70 write<=1;
   	#100write <=0;
   	end	

always@(zone1)
	begin
		#25 zone1 <= zone1 +1;
	end	
			
always@(zone2)
	begin
		#25  zone2 <= zone2 +1 ;
	end	
			
always@(zone3)
	begin
		#25 zone3  <=  zone3 +1;
	end	
always@(zone4)
	begin
		#25 zone4  <=  zone4 +1;
	end
	
endmodule


