`timescale 1ns/100ps
module test_bench_memory2;
reg clk1,clk2,clk3,clk0,write,d_in;
reg fault_FNO1, 
		fault_LSW1,
		fault_INV1, 
		fault1_MV2,
		fault0_MV2,
		fault_FNO2,
		fault_FNO3,
		fault_LSW5,
		fault_LSW3,
		fault1_MV3,
		fault0_MV3,
		fault1_MV1,
		fault0_MV1,
		fault_LSW2;
reg m5l,i2l,m2l,m12l,m15l, m7l,m8l,m6l,m16l,m10l,m9l;
wire out ;

Fanout FNO1(
		.in (write),
		.out1 (m1), 
		.out2 (m2), 
		.fault(fault_FNO1)
		);
		
LShapedWire LSW1(
		.in(m1), 
		.out(m4), 
		.fault(fault_LSW1)
		);		
		
Inverter INV1 (
		.in (m4),
		.out(m5),
		.fault(fault_INV1)
	);
reg i3=1'b1;
MajorityVoter MV2 (
		.A(m5l), 
		.B(m14), 
		.C(i3), 
		.out(m6),
		.fault1(fault1_MV2), 
		.fault0(fault0_MV2)
		);

LShapedWire LSW2(
		.in(m6l), 
		.out(m7), 
		.fault(fault_LSW2)
		);
wire i2=d_in;
Fanout FNO2(
		.in (i2l),
		.out1 (m14), 
		.out2 (m13), 
		.fault(fault_FNO2)
		);
		
MajorityVoter MV1 (
		.A(m2l), 
		.B(1'b0), 
		.C(m13), 
		.out(m12),
		.fault1(fault1_MV1), 
		.fault0(fault0_MV1)
		);		
wire m15=m12l;
MajorityVoter MV3 (
		.A(m15l), 
		.B(m9l), 
		.C(m7l), 
		.out(m8),
		.fault1(fault1_MV3), 
		.fault0(fault0_MV3)
		);		
wire m16=m8l;		
LShapedWire LSW3(
		.in(m11), 
		.out(m10), 
		.fault(fault_LSW3)
		);		
		
Fanout FNO3(
		.in (m16l),
		.out1 (out), 
		.out2 (m11), 
		.fault(fault_FNO3)
		);

LShapedWire LSW4(
		.in(m10l), 
		.out(m9), 
		.fault(fault_LSW5)
		);
initial  
begin     
		fault_FNO1=0;
		fault_LSW1=0;
		fault_INV1=0;
		fault1_MV2=0;
		fault0_MV2=0;
		fault_FNO2=0;
		fault_LSW2=0;
		fault_FNO3=0;
		fault_LSW5=0;
		fault_LSW3=0;
		fault1_MV3=0;
		fault0_MV3=0;
		fault1_MV1=0;
		fault0_MV1=0;
		m5l=1'bz;
		i2l=1'bz;
		m2l=1'bz;
		m12l=1'bz;
		m15l=1'bz;
		m7l=1'bz;
		m8l=1'b0;
		m6l=1'bz;
		m16l=1'bz;
		m10l=1'bz;
		m9l=1'bz;
		write=0;
		d_in=0;
/*		clk1= 1'b0;
		clk2=1'b0;
		clk3=1'b0;
		clk0=1'b0;*/
		#2.5 clk1 = 1;
		#2.5 clk2 = 1;
		#2.5 clk3 = 1;
		#2.5 clk0 = 1;
end     

always
	begin 
	#20 write=!write;
   	#40 d_in=!d_in;
   	end	

always@(posedge clk1)
//violet!
	begin
		m5l=m5;
		i2l=i2;
		m2l=m2;
		m16l=m16;
		clk1 = #5 ~clk1;
	end
always@(negedge clk1)
	begin
		m5l=1'bZ;
		m2l=1'bZ;
		i2l=1'bZ;
		m16l=1'bZ;
		clk1 = #5 ~clk1;
	end

always@(posedge clk2)
//blue
	begin
		m12l=m12;
		m6l=m6;
		m10l=m10;
		clk2 <= #5 ~clk2;
	end
	
always@(negedge clk2)
	begin
		m12l=1'bZ;
		m6l=1'bZ;
		m10l=1'bZ;
		clk2 <= #5 ~clk2;
	end
	
always@(posedge clk3)
//white
	begin
		m7l=m7;
		m15l=m15;
		m9l=m9;
		clk3 <= #5 ~clk3;
	end
	
always@(negedge clk3)
	begin
		m7l=1'bz;
		m15l=1'bz;
		m9l=1'bz;
		clk3 <= #5 ~clk3;
	end
	
always@(posedge clk0)
//green
	begin
		m8l=m8;
		clk0 <= #5 ~clk0;
	end
	
always@(negedge clk0)
	begin
		m8l=1'bZ;
		clk0 <= #5 ~clk0;
	end									
	


endmodule


