//`timescale 10ns/100ps
module test_benchLBMEM_new;

wire m8,m1,m2,m3,m4,m5,m6,m7,z;
reg x,y,nodefake, nodefake2, nodefake3;
reg [1:0] zone1,zone2,zone3;
parameter [1:0]
	switch=1,
	hold=2,
	rele=3,
	relax=0;
assign m8= nodefake;	
assign z= nodefake2;
assign out= nodefake2;
assign m3 = nodefake2;
assign m4 = nodefake2;
assign m1 = nodefake2;

Wire_4 W1 (
	   .A(x), 
	   .B(m1), 
	   .status(zone1)
	   );

Wire_4 W2 (
	    .A(y), 
	    .B(m7), 
	    .status(zone1)
	  );

Wire_bi6  WBI1 (
		.A(z), 
		.B(m3), 
		.status(zone1),
		.fault(0)
		);

MajorityVoter_bi4 MV1 (
			 .A(m1),
			 .B(m5), 
			 .Zp(m4),
			 .Z(m2),
			 .status(zone2), 
			 .fault1(1'b0), 
			 .fault0(1'b0)
			 );

Wire_bi6 W4 (
	   .A(m4), 
	   .B(m8), 
	   .status(zone2),
	   .fault(0)
	   );
	   
Wire_bi6 W5 (
	   .A(m8), 
	   .B(out), 
	   .status(zone3),
	   .fault(0)
	   );	   

LShapedWire_bi4 LSBI1(
		.A(m2), 
		.B(m3), 
		.fault(1'b0), 
		.status(zone2)
		);
		
LShapedWire_4 LS1 (
 		.A(m7), 
 		.B(m5), 
 		.status(zone2),
 		.fault(1'b0)
 		);


initial  
begin     
	x =0;     
 	y =0;
 	zone1<=2;
 	zone2<=2;
 	zone3<=3;
	nodefake <=0;
	nodefake3 <=1'bz;
	nodefake2 <=1'bz;
	#110	nodefake <=1'bz;
end     
always
    begin
	#50  x <=1;
	#0   y <=1;
	#200 x <=0;
	#0   y <=1;
	#200 x <=0;
	#0   y <=0;
	#200 x <=1;
	#0   y <=0;
	#200 x <=0;
	#0   y<=1; 
    end
//period=200
always@(zone1)
	begin
		case (zone1)
			hold : #100 zone1 <= zone1 +1;
			rele :  #25 zone1  <=  zone1 +1 ;
			relax : #50 zone1 <=  zone1 +1; 
			switch :  #25 zone1 <= zone1 +1 ;
		endcase
	end	
			
always@(zone2)
	begin
	#25  zone2 <= zone2 +1 ;
	end	
			
always@(zone3)
	begin
		case (zone3)
			hold : #75 zone3 <=  zone3 +1;
			rele : #25 zone3  <=  zone3 +1;
			relax :  #75  zone3 <= zone3 +1; 
			switch :  #25  zone3 <= zone3 +1;
		endcase
	end	

endmodule




