module Wire_bi4 (A, B, status);
//forward =1 information goes A-> B
//status 00=relax,01=switch, 10=hold, 11=release
// if fault =1 the output is inverted
	input [1:0] status;
	inout A,B;
	reg loadedA,loadedB;
	wor A,B,C;
assign C =  A;
assign C = B;
assign B =  (status == 2'b10) ? loadedB :
	    (status == 2'b01) ?	 C  : 1'bz;
assign A =  (status == 2'b10) ? loadedA :
	    (status == 2'b01) ?	 C : 1'bz;
initial
begin
	loadedA <=1'bz;
	loadedB <=1'bz;
end
always @ (posedge status[1])
	begin
		if (status[0]==0)
			begin
				loadedA <= (A===1'bx)? 1'bz: A;
				loadedB <= (B===1'bx)? 1'bz: B;
			end
	end
/*always @ (posedge status[0])
	 begin
		if (status[1]==1)
			begin
				loadedA <= 1'bz;
				loadedB <= 1'bz;
			end	
	end
*/	
endmodule

