//Coplanar crossing with fault injection capability
// if ~fault1 && fault0  out1  is ~in1
// if   fault1  && ~fault0 out2 is ~in1 (interference) 


module Crosswire (in1, in2, out1, out2, fault0, fault1);
	input in1, in2,  fault0, fault1;
	output out1, out2;
	// if ~fault1 && fault0  out1  is ~in1
	// if   fault1  && ~fault0 out2 is ~in1 (interference) 
	assign out1 = fault0 ? (~fault1 ? ~in1 : in1) : in1;
	assign out2 = fault1 ? (~fault0 ? ~in1 :in2)  : in2 ;
endmodule


