module MajorityVoter_bi6 (A, B, Zp, Z,status, fault1, fault0);
	//Z and Zp are bidirectional.

	input [1:0] status; //status 00=relax, 01=switch, 10=hold, 11=release
	input A,B;
	input fault1, fault0;
	inout Z,Zp;
	wor wi1, wi2, wi3;
	wor wi1p, wi2p, wi3p;
	wor Z,Zp;
	reg  latchZ, latchZp;
	// fault1=0 fault0=0 output fault free
	// fault1=1 fault0=0 output S a B
	// fault1=0(1) fault0=1 output Maj(A',B,C')
	assign wi1 = ((A & B) | (B & Z) | (A & Z));
	assign wi1p= ((A & B) | (B & Zp) | (A & Zp));
	assign wi3 = ((~A & B) | (B & ~Z) | (~A & ~Z));
	assign wi3p= ((~A & B) | (B & ~Zp) | (~A & ~Zp));
	assign wi2 = (fault1)?  B : wi1;
	assign wi2p = (fault1)?  B : wi1p;
	
	assign Zp  = (status==2'b10) ? latchZp :
		     (status==2'b01)  ?  ((fault0) ?  ((wi3===1'bx) ? 1'bz: wi3) : ((wi2===1'bx) ? 1'bz : wi2) ):
		     1'bz;
	
	assign Z   = (status==2'b10 ) ? latchZ:
		     (status==2'b01 ) ?  ((fault0) ?  ((wi3p===1'bx )? 1'bz :wi3p) : ((wi2p===1'bx)? 1'bz : wi2p) ):
		     1'bz;
initial
	begin
	latchZp =1'bZ;
	latchZ=1'bZ;
	end
always@ (posedge status[0])
begin
	always@(Zp or Z)
	begin
		if (Zp ===1'bz)
		 begin
		    latchZp <= Z;
		    latchZ <= Zp;
		 end   
		if (Z====1'bz) 
	end
end

always@(posedge status[1])
		begin
		if (status[0]==0)
			begin
				latchZp	<= Zp===1'bx ?  1'bz :Zp;
				latchZ  <= Z===1'bx ?  1'bz :Z ;
			end
		end
endmodule
