module MajorityVoter_bi2 (A, B, Zp, Z,status, fault1, fault0);
	//Z and Zp are bidirectional.
	//if forward =1, Zp is output and Z is input, the opposite otherwise.
	//note: forward can't change if not together with a status change.
	input [1:0] status; //status 00=relax, 01=switch, 10=hold, 11=release
	input A,B;
	input fault1, fault0;
	inout Z,Zp;
	wor wi1, wi2, wi3;
	wor wi1p, wi2p, wi3p;
	wor Z,Zp;
	reg  latchZ, latchZp;
	// fault1=0 fault0=0 output fault free
	// fault1=1 fault0=0 output S a B
	// fault1=0(1) fault0=1 output Maj(A',B,C')

	assign  forward = (Z===1'bz && Zp!==1'bz) ? 1: (Zp===1'bz && Z!==1'bz) ? 0 : 1'bz;
	assign latch_sig = ~status[0] & status[1];
	assign wi1 = ((A & B) | (B & Z) | (A & Z));
	assign wi1p= ((A & B) | (B & Zp) | (A & Zp));
	assign wi3 = ((~A & B) | (B & ~Z) | (~A & ~Z));
	assign wi3p= ((~A & B) | (B & ~Zp) | (~A & ~Zp));
	assign wi2 = (fault1)?  B : wi1;
	assign wi2p = (fault1)?  B : wi1p;
	assign Zp  = (status==2'b10) ? latchZp :
		     (status==2'b01)  ?  (forward ? ((fault0) ?  wi3: wi2) :1'bz) :
		      1'bz;
	assign Z   = (status==2'b10 ) ? latchZ:
		     (status==2'b01 ) ? ((forward===0) ? ((fault0) ?  wi3p: wi2p) : 1'bz):
		      1'bz;
	initial
	begin
	latchZp =1'bZ;
	latchZ=1'bZ;
	end
	always@(posedge status[1])
		begin
		if (status[0]==0)
			begin
				//latched <= ((fault0) ?  wi3: wi2);
				latchZp	<=  Zp ;
				latchZ    <= Z;
			end
		end
endmodule
