module MajorityVoter_4 (A, B, C, Zp,status, fault1, fault0);


	input [1:0] status; //status 00=relax, 01=switch, 10=hold, 11=release
	input A,B,C;
	input fault1, fault0;
	output Zp;
	wor wi1, wi2, wi3;

	wor Zp;
	reg latchZp;
	// fault1=0 fault0=0 output fault free
	// fault1=1 fault0=0 output S a B
	// fault1=0(1) fault0=1 output Maj(A',B,C')
	////assign  forward = (Z===1'bz && Zp!==1'bz) ? 1: (Zp===1'bz && Z!==1'bz) ? 0 : 1'bz;
	//assign latch_sig = ~status[0] & status[1];
	assign wi1 = ((A & B) | (B & C) | (A & C));

	assign wi3 = ((~A & B) | (B & ~C) | (~A & ~C));

	assign wi2 = (fault1)?  B : wi1;

	
	assign Zp  = (status==2'b10) ? latchZp :
		     (status==2'b01)  ?  ((fault0) ?  ((wi3===1'bx) ? 1'bz: wi3) : ((wi2===1'bx) ? 1'bz : wi2) ):
		     1'bz;
	
initial
	begin
	latchZp =1'bZ;
	end
always@(posedge status[1])
			begin
				latchZp	<= Zp===1'bx ?  1'bz :Zp;
			end
always@(posedge status[1])
		begin
		 latchZp	<= 1'bz;
		end
	
endmodule
