module LShapedWire_4 (A, B, fault, status);
//forward =1 information goes A-> B
//status 00=relax,01=switch, 10=hold, 11=release
// if fault =1 the output is inverted
	input [1:0] status;
	input fault;
	inout A,B;
	reg loadedA,loadedB;
	wor A,B;
assign B =  (status == 2'b10) ? loadedB :
	    (status == 2'b01) ?	(fault ? ~A : A) : 1'bz;

initial
begin
	loadedB <=1'bz;
end
always @ (posedge status[1])
	begin
		if (status[0]==0)
			begin
				loadedB <= (B===1'bx) ? 1'bz: B;
			end
	end
endmodule

