module Fanout_bi4 (A, B, C, status, fault);
//   A
//   |-	C
//   B
//forward =1 information goes A-> B D->E
//status 00=relax,01=switch, 10=hold, 11=release
// if fault =1 the out is inverted if in the "L shaped " path
	input [1:0] status;
	input fault;
	inout A,B,C;
	reg loadedA,loadedB,loadedC;
	wor A,B,C,D,E,F;
	
assign D = A;
assign D = C;
assign E = A;
assign E = B;
assign F = C;
assign F = B;

assign B =  (status == 2'b10) ? loadedB :
	    (status == 2'b01) ?	(fault ? (A===1'bz  ?  ~D : D)  :D)  : 1'bz;
assign A =  (status == 2'b10) ? loadedA :
	    (status == 2'b01) ?	(fault ? (B===1'bz ?  ~F : F)  :F)  : 1'bz;
assign C =  (status == 2'b10) ? loadedC :
	    (status == 2'b01) ?	(fault ? ~E : E)  : 1'bz;

	    
initial
begin
	loadedA <=1'bz;
	loadedB <=1'bz;
	loadedC <=1'bz;
end

always @ (posedge status[1])

			begin
				loadedA <= (A===1'bx)? 1'bz: A;
				loadedB <= (B===1'bx)? 1'bz: B;
				loadedC <= (C===1'bx)? 1'bz: C;
			end

always@(posedge status[0])
	begin
		loadedA <= 1'bz;
		loadedB <= 1'bz;
		loadedC <= 1'bz;
	end	

endmodule