module CrossWire_bi4 (A, B, D, E, status, fault0, fault1);
//forward =1 information goes A-> B D->E
//status 00=relax,01=switch, 10=hold, 11=release
// if ~fault1 && fault0  B(A)  is ~A(~B)
// if   fault1  && ~fault0 E(~D) is ~D (~E) (interference) 
	input [1:0] status;
	input fault1, fault0;
	inout A,B, D, E;
	reg loadedA,loadedB,loadedD,loadedE;
	wor A,B,C,D,E,F;
assign C = A;
assign C = B;
assign F = D;
assign F = E;
assign B =  (status == 2'b10) ? loadedB :
	    (status == 2'b01) ?	(fault0 ? ((~fault1) ?  ~C : C) :C)  : 1'bz;
assign A =  (status == 2'b10) ? loadedA :
	    (status == 2'b01) ?	(fault0 ? (~fault1 ?  ~C : C)  :C)  : 1'bz;
assign D =  (status == 2'b10) ? loadedD :
	    (status == 2'b01) ?	(fault1 ? (~fault0 ?  ~F : F) :F)  : 1'bz;
assign E =  (status == 2'b10) ? loadedE :
	    (status == 2'b01) ?	(fault1 ? (~fault0 ?  ~F : F) :F)   : 1'bz;
	    
initial
begin
	loadedA <=1'bz;
	loadedB <=1'bz;
	loadedD <=1'bz;
	loadedE <=1'bz;
end
always @ (posedge status[1])
	begin
		if (status[0]==0)
			begin
				loadedA <= (A===1'bx)? 1'bz: A;
				loadedB <= (B===1'bx)? 1'bz: B;
				loadedD <= (D===1'bx)? 1'bz: D;
				loadedE <= (E===1'bx)? 1'bz: E;
			end
	end
endmodule
