module CrossWire_4 (A, B, D, E, status, fault0, fault1);
//forward =1 information goes A-> B D->E
//status 00=relax,01=switch, 10=hold, 11=release
// if ~fault1 && fault0  B(A)  is ~A(~B)
// if   fault1  && ~fault0 E(~D) is ~D (~E) (interference) 
	input [1:0] status;
	input fault1, fault0;
	input A,B;
	output  D,E;
	reg loadedB,loadedE;
	wor A,B,D,E;

assign B =  (status == 2'b10) ? loadedB :
	    (status == 2'b01) ?	(fault0 ? ((~fault1) ?  ~A : A) :A)  : 1'bz;

assign E =  (status == 2'b10) ? loadedE :
	    (status == 2'b01) ?	(fault1 ? (~fault0 ?  ~D : D) :D)   : 1'bz;
	    
initial
begin
	loadedB <=1'bz;
	loadedE <=1'bz;
end
always @ (posedge status[1])
	begin
		if (status[0]==0)
			begin
				loadedB <= (B===1'bx)? 1'bz: B;
				loadedE <= (E===1'bx)? 1'bz: E;
			end
	end
endmodule
