module test_bench_MUX;
reg A,B,sel;
reg f1,f2,f3,f4,f5,f6,f7,f8,f9,f10,f11,f12,f13,f14,f15;
wire w1,w2,w3,w4,w5,w6,w7,w8,w9,w10,w11,w12,w13,w14,out;

Fanout Fanout1 (
	.in (sel),
	.out1(w6),
	.out2(w7),
	.fault(f5)
	);
LShapedWire LS1 (
	.in (A),
	.out(w1),
	.fault(f1)
	);
LShapedWire LS4 (
	.in (B),
	.out(w12),
	.fault(f13)
	);
LShapedWire LS3 (
	.in (w8),
	.out(w9),
	.fault(f14)
	);
LShapedWire LS2 (
	.in (w7),
	.out(w8),
	.fault(f15)
	);
LShapedWire LS5 (
	.in (w5),
	.out(w4),
	.fault(f7)
	);
LShapedWire LS6 (
	.in (w10),
	.out(w11),
	.fault(f10)
	);
LShapedWire LS7 (
	.in (w2),
	.out(w3),
	.fault(f4)
	);

Inverter INV1 (
	.in (w6),
	.out(w5),
	.fault(f6)
	);

MajorityVoter MV1 (
	.A (w1),
	.B (0),
	.C (w4),
	.out (w2),
	.fault1 (f3),
	.fault0 (f2)
	);

MajorityVoter MV2 (
	.A (w9),
	.B (0),
	.C (w12),
	.out (w10),
	.fault1(f12),
	.fault0 (f11)
	);

MajorityVoter MV3 (
	.A (w3),
	.B (1),
	.C (w11),
	.out (out),
	.fault1 (f9),
	.fault0 (f8)
	);
or (outFaultFree, w13,w14);
and (w13, A,~sel);
and (w14, B,sel);

initial  
begin     
	A = 0;     
	B = 0;     
	sel = 0;
	f1 = 0;     
	f2 = 0;     
	f3 = 0;     
	f4 = 0;     
	f5 = 0;     
	f6 = 0;     
	f7 = 0;     
	f8 = 0;     
	f9 = 0;     
	f10 = 0;     
	f11 = 0;     
	f12 = 0;     
	f13 = 0;     
	f14 = 0;     
	f15 = 0;     
end     

always
     #5 A = !A;
always
     #10 B = !B;

always
     #20 sel = !sel;
always
     #40 f1 = !f1;
always
     #80 f2 = !f2;
always
     #160 f3 = !f3;
always
     #320 f4 = !f4;
always
     #640 f5 = !f5;
always
     #1280 f6 = !f6;
always
     #2560 f7 = !f7;
always
     #5120 f8 = !f8;
always
     #10240 f9 = !f9;
always
     #20480 f10 = !f10;
always
     #40960 f11 = !f11;
always
     #81920 f12 = !f12;
always
     #163840 f13 = !f13;
always
     #327680 f14 = !f14;
always
     #655360 f15 = !f15;

endmodule









