//`timescale 10ns/100ps
module test_benchkinks;

wire m8,m1,m2,m3,m4,m5,m6,m7,z;
reg x,y,w;
reg fault_1,fault_2,fault_3,fault_4,fault_5,fault_6;
reg [1:0] zone1,zone2,zone3;
parameter [1:0]
	switch=1,
	hold=2,
	rele=3,
	relax=0;
assign x1=x;
assign y1=y;
assign w1=w;
assign fakenode =1'bz;
//assign x1=fakenode;
//assign y1=fakenode;
//assign z1=fakenode;
assign m1=fakenode;
assign m2=fakenode;
assign m3=fakenode;
assign m4=fakenode;
assign m5=fakenode;
assign m6=fakenode;
Wire_bi6 W1 (
	   .A(x1), 
	   .B(m1),
 	   .fault(fault_1), 
	   .status(zone1)
	   );

Wire_bi6 W2 (
	    .A(y1), 
	    .B(m2),
	    .fault(fault_2), 
	    .status(zone1)
	  );

Wire_bi6 W3 (
	    .A(w1), 
	    .B(m3),
	    .fault(fault_3), 
	    .status(zone1)
	  );
	  
Wire_bi6 W4 (
	    .A(m1), 
	    .B(m4),
	    .fault(fault_4), 
	    .status(zone2)
	  );
	  
Wire_bi6 W5 (
	    .A(m2), 
	    .B(m5),
	    .fault(fault_5), 
	    .status(zone2)
	  );
	  
Wire_bi6 W6 (
	    .A(m3), 
	    .B(m6),
	    .fault(fault_6), 
	    .status(zone2)
	  );

MajorityVoter_bi4 MV1 (
			 .A(m4),
			 .B(m5), 
			 .Zp(m6),
			 .Z(out),
			 .status(zone3), 
			 .fault1(1'b0), 
			 .fault0(1'b0)
			 );


initial  
begin     
	x <=1;     
 	y <=0;
 	w <=1;
 	zone1<=relax;
 	zone2<=rele;
 	zone3<=hold;
	fault_1 <=0;
	fault_2 <=0;
	fault_3 <=0;
	fault_4 <=0;
	fault_5 <=0;
	fault_6 <=0;
end     

//always
  //  begin
//	#50  x <=1;
	//#0   y <=1;
//	#200 w <=0;
//	#0   x <=1;
	//#200 x <=0;
//	#0  y <=0;
//	#200 w <=1;
//	#0   y <=1;
//	#200 x <=0;
//	#0   y<=1; 
 //   end
always
     begin
       #250  fault_4 <= ~fault_4;
       #25 fault_4 <= ~fault_4;
     end  
//period=200

always@(zone1)
	begin
	#25  zone1 <= zone1 +1 ;
	end				
always@(zone2)
	begin
	#25  zone2 <= zone2 +1 ;
	end	
always@(zone3)
	begin
	#25  zone3 <= zone3 +1 ;
	end

endmodule




