module test_bench_EXOR;
reg in1,in2;
reg f1,f2,f3,f4,f5,f6,f7,f8,f9,f10,f11,f12,f13,f14,f15,f16;
wire w1,w2,w3,w4,w5,w6,w7,w8,w9,w10,w11,w12,w13,w14,out,outFaultFree;

Fanout Fanout1 (
	.in (in1),
	.out1(w9),
	.out2(w1),
	.fault(f1)
	);
Fanout Fanout2 (
	.in (in2),
	.out1(w4),
	.out2(w5),
	.fault(f6)
	);
LShapedWire LS1 (
	.in (w9),
	.out(w10),
	.fault(f14)
	);
LShapedWire LS4 (
	.in (w10),
	.out(w11),
	.fault(f15)
	);
LShapedWire LS3 (
	.in (w4),
	.out(w14),
	.fault(f7)
	);
LShapedWire LS2 (
	.in (w5),
	.out(w6),
	.fault(f10)
	);
LShapedWire LS5 (
	.in (w3),
	.out(w12),
	.fault(f5)
	);
LShapedWire LS6 (
	.in (w8),
	.out(w13),
	.fault(f16)
	);

Inverter INV1 (
	.in (w1),
	.out(w2),
	.fault(f2)
	);

Inverter INV2 (
	.in (w6),
	.out(w7),
	.fault(f11)
	);

MajorityVoter MV1 (
	.A (w2),
	.B (0),
	.C (w14),
	.out (w3),
	.fault1 (f4),
	.fault0 (f3)
	);

MajorityVoter MV2 (
	.A (w7),
	.B (0),
	.C (w11),
	.out (w8),
	.fault1(f13),
	.fault0 (f12)
	);

MajorityVoter MV3 (
	.A (w12),
	.B (1),
	.C (w13),
	.out (out),
	.fault1 (f9),
	.fault0 (f8)
	);


xor (outFaultFree, in1,in2);



initial  
begin     
	in1 = 0;     
	in2 = 0;     
	f1 = 0;     
	f2 = 0;     
	f3 = 0;     
	f4 = 0;     
	f5 = 0;     
	f6 = 0;     
	f7 = 0;     
	f8 = 0;     
	f9 = 0;     
	f10 = 0;     
	f11 = 0;     
	f12 = 0;     
	f13 = 0;     
	f14 = 0;     
	f15 = 0;     
	f16 = 0;     
end     

// exhaustive stimuli
always
     #5 in1 = !in1;
always
     #10 in2 = !in2;

always
     #20 f1 = !f1;
always
     #40 f2 = !f2;
always
     #80 f3 = !f3;
always
     #160 f4 = !f4;
always
     #320 f5 = !f5;
always
     #640 f6 = !f6;
always
     #1280 f7 = !f7;
always
     #2560 f8 = !f8;
always
     #5120 f9 = !f9;
always
     #10240 f10 = !f10;
always
     #20480 f11 = !f11;
always
     #40960 f12 = !f12;
always
     #81920 f13 = !f13;
always
     #163840 f14 = !f14;
always
     #327680 f15 = !f15;
always
     #655360 f16 = !f16;


/* 2 faults stimuli TODO
always
     #5 in1 = !in1;
always
     #10 in2 = !in2;
always
     #20 f1 = !f1;
always
     #40 f2 = !f2;
always
     #80 f3 = !f3;
always
     #160 f4 = !f4;
always
     #320 f5 = !f5;
always
     #640 f6 = !f6;
always
     #1280 f7 = !f7;
always
     #2560 f8 = !f8;
always
     #5120 f9 = !f9;
always
     #10240 f10 = !f10;
always
     #20480 f11 = !f11;
always
     #40960 f12 = !f12;
always
     #81920 f13 = !f13;
always
     #163840 f14 = !f14;
always
     #327680 f15 = !f15;
always
     #655360 f16 = !f16;
*/
endmodule








