module Inverter_new (A, B, status, fault);
//forward =1 information goes A-> B
//status 00=relax,01=switch, 10=hold, 11=release
// if fault =1 the output is inverted
	input [1:0] status;
	input fault;
	inout A,B;
	reg loadedA,loadedB;
	wor A,B,C,D,E;
assign C =  A;
//assign C =  B===1'bz ? 1'bz :!B;
//assign D =  B;
//assign E =  A;
assign B =  (status == 2'b10) ? loadedB :
	    (status == 2'b01) ?	(fault==0 ? !C : C): 1'bz;
assign A =  (status == 2'b10) ? loadedA :
	    1'bz;
initial
begin
	loadedA <=1'bz;
	loadedB <=1'bz;
end

//always@(posedge fault)
	//deassign (C);
	
always@(posedge status[1])
	begin
		loadedA <= (A===1'bx)? 1'bz: A;
		loadedB <= (B===1'bx)? 1'bz: ~A;
	end

always@(posedge status[0])
	begin
		loadedA <= 1'bz;
		loadedB <= 1'bz;
	end	
			
endmodule