module Inverter_4 (A, B, status, fault);
//forward =1 information goes A-> ~B
//status 00=relax,01=switch, 10=hold, 11=release
	// if fault =1  out is not inverted
	//assign out = fault ? in : ~in;

	input [1:0] status;
	input fault;
	input A;
	output B;
	reg loaded;
	wor A,B;

assign B =  (status == 2'b10) ? loaded :
	    (status == 2'b01) ?	(fault ? A : ~A)  : 
	     1'bz ;

	    
initial
begin
	loaded <=1'bz;
end

always @ (posedge status[1])
	begin
	   loaded <= (B===1'bx)? 1'bz: B;
	end

always@(posedge status[0])
	begin
		loaded<= 1'bz;
	end	
		

endmodule
	
		