module Fanout_C4 (A, B, C, status, fault);
//   A
//   |-	C
//   B
//forward =1 information goes C-> B & A
//status 00=relax,01=switch, 10=hold, 11=release
// if fault =1 the out is inverted if in the "L shaped " path (both B and A)
	input [1:0] status;
	input fault;
	input C;
	output B,A;
	reg loadedB,loadedA;
	wor A,B,C;


assign B =  (status == 2'b10) ? loadedB :
	    (status == 2'b01) ?	(fault ? ~C : C): 1'bz;

assign A =  (status == 2'b10) ? loadedA :
	    (status == 2'b01) ?	(fault ? ~C : C)  : 1'bz;

	    
initial
begin
	loadedB <=1'bz;
	loadedA <=1'bz;
end

always @ (posedge status[1])
	begin
		if (status[0]==0)
			begin
				loadedB <= (B===1'bx)? 1'bz: B;
				loadedA <= (A===1'bx)? 1'bz: A;
			end
	end
endmodule