module Fanout_A4 (A, B, C, status, fault);
//   A
//   |-	C
//   B
//forward =1 information goes A-> B & C
//status 00=relax,01=switch, 10=hold, 11=release
// if fault =1 the out is inverted if in the "L shaped " path (C)
	input [1:0] status;
	input fault;
	input A;
	output B,C;
	reg loadedB,loadedC;
	wor A,B,C;


assign B =  (status == 2'b10) ? loadedB :
	    (status == 2'b01) ?	A  : 1'bz;

assign C =  (status == 2'b10) ? loadedC :
	    (status == 2'b01) ?	(fault ? ~A : A)  : 1'bz;

	    
initial
begin
	loadedB <=1'bz;
	loadedC <=1'bz;
end

always @ (posedge status[1])
	begin
	

				loadedB <= (B===1'bx)? 1'bz: B;
				loadedC <= (C===1'bx)? 1'bz: C;
	
	end


always@(posedge status[0])
	begin
		loadedA <= 1'bz;
		loadedB <= 1'bz;
	end	


endmodule